/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet.impl;

import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.impl.TaskletRegistryEntry;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.Map;

public final class TaskletRegistry {
    private static final String TRACE_MASKT = "XTSKSTRT";
    private static final String TRACE_MASKF = "XTSKSTRF";
    private static final String TRACE_MASKD = "XTSKSTRD";
    private static TaskletRegistry theRegistry = null;
    private static int nextTasketId = 0;
    private Map registry = new HashMap();

    public static synchronized TaskletRegistry getRegistry() {
        if (theRegistry == null) {
            theRegistry = new TaskletRegistry();
        }
        return theRegistry;
    }

    public static synchronized int getNextTaskletId() {
        return nextTasketId++;
    }

    private TaskletRegistry() {
    }

    public synchronized TaskletRegistryEntry get(int key) {
        Trace.trace(TRACE_MASKF, "[TaskletRegistry] get(" + key + ")");
        return (TaskletRegistryEntry)this.registry.get(new Integer(key));
    }

    public void put(int key, TaskletRegistryEntry taskletRegistryEntry) {
        Trace.trace(TRACE_MASKF, "[TaskletRegistry] put(" + key + ", " + taskletRegistryEntry + ")");
        this.registry.put(new Integer(key), taskletRegistryEntry);
    }

    public synchronized boolean contains(int id) {
        return this.registry.containsKey(new Integer(id));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void associate(int childTaskletId, int parentId) {
        Trace.trace(TRACE_MASKF, "[TaskletRegistry] associate( " + childTaskletId + ", " + parentId + " )");
        if (parentId != -1) {
            TaskletRegistryEntry child_tre = this.get(childTaskletId);
            if (child_tre == null) throw new RuntimeException("Unable to find child entry to associate!");
            Tasklet childTasklet = child_tre.tasklet;
            if (childTasklet == null) throw new RuntimeException("Found entry but no child existed to associate!");
            if (!(childTasklet instanceof PanelTasklet)) return;
            TaskletRegistryEntry parent_tre = this.get(parentId);
            if (parent_tre == null) throw new RuntimeException("Unable to find parent entry to associate!");
            Tasklet parent = parent_tre.tasklet;
            if (parent == null || !(parent instanceof PanelTasklet)) throw new RuntimeException("Found entry but no parent existed to associate!");
            ((PanelTasklet)parent).addSubtaskletChild((PanelTasklet)childTasklet);
            ((PanelTasklet)childTasklet).setParent((PanelTasklet)parent);
            Trace.trace(TRACE_MASKF, "[TaskletRegistry] Associating parent(" + parent.getTaskletId() + ") and child(" + childTasklet.getTaskletId() + ")");
            return;
        } else {
            Trace.trace(TRACE_MASKF, "[TaskletRegistry] parentId is unspecified, ignoring call");
        }
    }

    public synchronized TaskletRegistryEntry remove(int key) {
        PanelTasklet parent;
        Tasklet tasklet;
        Trace.trace(TRACE_MASKF, "[TaskletRegistry] remove(" + key + ")");
        TaskletRegistryEntry tre = (TaskletRegistryEntry)this.registry.remove(new Integer(key));
        Tasklet tasklet2 = tasklet = tre != null ? tre.tasklet : null;
        if (tasklet != null && tasklet instanceof PanelTasklet && (parent = ((PanelTasklet)tasklet).getParent()) != null) {
            parent.removeSubtaskletChild((PanelTasklet)tasklet);
            Trace.trace(TRACE_MASKF, "[TaskletRegistry] Disassociating parent(" + parent.getTaskletId() + ") and child(" + tasklet.getTaskletId() + ")");
            ((PanelTasklet)tasklet).setParent(null);
        }
        return tre;
    }
}

